"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.admin = exports.app = void 0;
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const body_parser_1 = __importDefault(require("body-parser"));
const helmet_1 = __importDefault(require("helmet"));
const compression_1 = __importDefault(require("compression"));
const morgan_1 = __importDefault(require("morgan"));
const firebase_admin_1 = __importDefault(require("firebase-admin"));
exports.admin = firebase_admin_1.default;
// Import Routes
const auth_routes_js_1 = __importDefault(require("./routes/auth.routes.js"));
const notification_routes_1 = __importDefault(require("./routes/notification.routes"));
const product_routes_1 = __importDefault(require("./routes/product.routes"));
const user_routes_1 = __importDefault(require("./routes/user.routes"));
const cart_routes_1 = __importDefault(require("./routes/cart.routes"));
const address_routes_1 = __importDefault(require("./routes/address.routes"));
const category_routes_1 = __importDefault(require("./routes/category.routes"));
const dashboard_routes_1 = __importDefault(require("./routes/admin/dashboard.routes"));
const customer_routes_1 = __importDefault(require("./routes/admin/customer.routes"));
const category_routes_2 = __importDefault(require("./routes/admin/category.routes"));
const inventory_routes_1 = __importDefault(require("./routes/admin/inventory.routes"));
const order_routes_1 = __importDefault(require("./routes/admin/order.routes"));
const support_routes_1 = __importDefault(require("./routes/admin/support.routes"));
const marketing_routes_1 = __importDefault(require("./routes/admin/marketing.routes"));
const announcement_routes_1 = __importDefault(require("./routes/admin/announcement.routes"));
const banner_routes_1 = __importDefault(require("./routes/admin/banner.routes"));
const review_routes_1 = __importDefault(require("./routes/admin/review.routes"));
const variant_routes_1 = __importDefault(require("./routes/admin/variant.routes"));
const product_routes_2 = __importDefault(require("./routes/admin/product.routes"));
const setting_routes_1 = __importDefault(require("./routes/admin/setting.routes"));
const featured_routes_1 = __importDefault(require("./routes/admin/featured.routes"));
const featured_category_routes_1 = __importDefault(require("./routes/admin/featured-category.routes"));
const wishlist_routes_1 = __importDefault(require("./routes/wishlist.routes"));
const checkout_routes_1 = __importDefault(require("./routes/checkout.routes"));
const cms_routes_1 = __importDefault(require("./routes/cms.routes"));
const featuredBanner_routes_1 = __importDefault(require("./routes/admin/featuredBanner.routes"));
const app = (0, express_1.default)();
exports.app = app;
// 🌐 CORS Configuration
app.use((0, cors_1.default)({
    origin: [process.env.FRONTEND_URL, process.env.FRONTEND_URL_ADMIN],
    methods: ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'],
    credentials: true,
}));
// app.set('trust proxy', true);
//  Rate Limiting
// const limiter = rateLimit({
//   windowMs: 1 * 60 * 1000, // 1 minute
//   max: 50, // max 50 requests
//   handler: (req, res) => {
//     console.log(`Rate limit hit`);
//     res.status(429).json({ message: 'Too many requests, slow down!' });
//   },
//   standardHeaders: true,
//   legacyHeaders: false,
// });
// app.use(limiter);
// 🧩 Global Middlewares
app.use((0, cookie_parser_1.default)());
app.use((0, helmet_1.default)());
app.use((0, compression_1.default)());
app.use((0, morgan_1.default)('short'));
app.use(express_1.default.json({ limit: '5mb' }));
app.use(body_parser_1.default.urlencoded({ extended: true, limit: '5mb' }));
app.use(express_1.default.static('./public'));
// 🧯 Error Handler Middleware
// app.use(errorHandler);
// 🩵 Health Check Route
app.get('/', (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    return res.status(200).json({ success: false, message: 'nice to meet' });
}));
// 🧭 Register All Routes
app.use('/api/v1/auth', auth_routes_js_1.default);
app.use('/api/v1/users', user_routes_1.default);
app.use('/api/v1/product', product_routes_1.default);
app.use('/api/v1/notifications', notification_routes_1.default);
app.use('/api/v1/cart', cart_routes_1.default);
app.use('/api/v1/address', address_routes_1.default);
app.use('/api/v1/category', category_routes_1.default);
// admin routes
app.use('/api/v1/admin/dashboard', dashboard_routes_1.default);
app.use('/api/v1/admin/customer', customer_routes_1.default);
app.use('/api/v1/admin/category', category_routes_2.default);
app.use('/api/v1/admin/inventory', inventory_routes_1.default);
app.use('/api/v1/admin/order', order_routes_1.default);
app.use('/api/v1/admin/support', support_routes_1.default);
app.use('/api/v1/admin/marketing', marketing_routes_1.default);
app.use('/api/v1/admin/announcements', announcement_routes_1.default);
app.use('/api/v1/admin/banner', banner_routes_1.default);
app.use('/api/v1/admin/reviews', review_routes_1.default);
app.use('/api/v1/admin/variants', variant_routes_1.default);
app.use('/api/v1/admin/products', product_routes_2.default);
app.use('/api/v1/admin/settings', setting_routes_1.default);
app.use('/api/v1/admin/featured', featured_routes_1.default);
app.use('/api/v1/admin/featuredbanners', featuredBanner_routes_1.default);
app.use('/api/v1/admin/bento', featured_category_routes_1.default);
app.use('/api/v1/wishlist', wishlist_routes_1.default);
app.use('/api/v1/checkout', checkout_routes_1.default);
app.use('/api/v1/cms', cms_routes_1.default);
