"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteAnnouncement = exports.updateAnnouncement = exports.createAnnouncement = exports.getAnnouncements = void 0;
const client_1 = require("@prisma/client");
const prisma = new client_1.PrismaClient();
// GET /api/admin/announcements
const getAnnouncements = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const announcements = yield prisma.announcement.findMany({
            orderBy: { createdAt: 'desc' },
        });
        res.json(announcements);
    }
    catch (error) {
        console.error("Get Announcements Error:", error);
        res.status(500).json({ error: "Failed to fetch announcements" });
    }
});
exports.getAnnouncements = getAnnouncements;
// POST /api/admin/announcements
const createAnnouncement = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { text, isActive } = req.body;
        if (!text) {
            return res.status(400).json({ error: "Announcement text is required" });
        }
        const newAnnouncement = yield prisma.announcement.create({
            data: {
                text,
                isActive: isActive !== undefined ? isActive : true,
            },
        });
        res.status(201).json(newAnnouncement);
    }
    catch (error) {
        console.error("Create Announcement Error:", error);
        res.status(500).json({ error: "Failed to create announcement" });
    }
});
exports.createAnnouncement = createAnnouncement;
// PUT /api/admin/announcements/:id
const updateAnnouncement = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { id } = req.params;
        const { text, isActive } = req.body;
        const updated = yield prisma.announcement.update({
            where: { id },
            data: {
                text,
                isActive,
            },
        });
        res.json(updated);
    }
    catch (error) {
        console.error("Update Announcement Error:", error);
        res.status(500).json({ error: "Failed to update announcement" });
    }
});
exports.updateAnnouncement = updateAnnouncement;
// DELETE /api/admin/announcements/:id
const deleteAnnouncement = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { id } = req.params;
        yield prisma.announcement.delete({ where: { id } });
        res.json({ message: "Announcement deleted successfully" });
    }
    catch (error) {
        console.error("Delete Announcement Error:", error);
        res.status(500).json({ error: "Failed to delete announcement" });
    }
});
exports.deleteAnnouncement = deleteAnnouncement;
