"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteReview = exports.replyToReview = exports.getReviews = void 0;
const client_1 = require("@prisma/client");
const prisma = new client_1.PrismaClient();
// GET /api/admin/reviews
const getReviews = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const reviews = yield prisma.review.findMany({
            include: {
                user: { select: { fullName: true, image: true } },
                product: { select: { name: true, images: true } },
            },
            orderBy: { createdAt: 'desc' },
            take: 50,
        });
        // Format data for easier consumption by frontend
        const formattedReviews = reviews.map((review) => ({
            id: review.id,
            user: review.user.fullName || 'Anonymous',
            userImage: review.user.image,
            product: review.product.name,
            rating: review.rating,
            comment: review.comment,
            reply: review.reply,
            status: review.status,
            date: review.createdAt.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' }),
        }));
        res.json(formattedReviews);
    }
    catch (error) {
        console.error("Get Reviews Error:", error);
        res.status(500).json({ error: "Failed to fetch reviews" });
    }
});
exports.getReviews = getReviews;
// PUT /api/admin/reviews/:id/reply
const replyToReview = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { id } = req.params;
        const { reply } = req.body;
        if (!reply)
            return res.status(400).json({ error: "Reply content is required" });
        const updatedReview = yield prisma.review.update({
            where: { id },
            data: { reply },
        });
        // TODO: Send email notification to user here via nodemailer
        res.json({ message: "Reply posted successfully", review: updatedReview });
    }
    catch (error) {
        console.error("Reply Review Error:", error);
        res.status(500).json({ error: "Failed to post reply" });
    }
});
exports.replyToReview = replyToReview;
// DELETE /api/admin/reviews/:id
const deleteReview = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { id } = req.params;
        yield prisma.review.delete({ where: { id } });
        res.json({ message: "Review deleted successfully" });
    }
    catch (error) {
        console.error("Delete Review Error:", error);
        res.status(500).json({ error: "Failed to delete review" });
    }
});
exports.deleteReview = deleteReview;
