"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateHeritageStory = exports.getHeritageStory = void 0;
const db_1 = __importDefault(require("../DB/db"));
const asyncHandler_1 = __importDefault(require("../utils/asyncHandler"));
const apiResponse_1 = __importDefault(require("../utils/apiResponse"));
const apiError_1 = __importDefault(require("../utils/apiError"));
const r2_1 = require("../utils/r2");
// --- GET: Fetch Heritage Story (Public) ---
exports.getHeritageStory = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    // Always fetch the first active record (assuming single section)
    const story = yield db_1.default.heritageStory.findFirst({
        where: { isActive: true },
    });
    // If no data exists yet, return default mock data so frontend doesn't break
    const data = story || {
        tagline: "The Philosophy",
        title: "Celebrating India's Artisanal Legacy",
        description: "Fabindia is more than a brand; it is a bridge between the artisan and the urban consumer.",
        imageUrl: "https://images.unsplash.com/photo-1606293926075-69a00dbfde81",
        buttonText: "Read Our Story",
        buttonLink: "/about",
    };
    return res.status(200).json(new apiResponse_1.default(true, 200, "Heritage story fetched successfully", data));
}));
// --- UPDATE: Modify Heritage Story (Admin Only) ---
exports.updateHeritageStory = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { tagline, title, description, buttonText, imageUrl, buttonLink } = req.body;
    // Check if a record exists
    const existingStory = yield db_1.default.heritageStory.findFirst();
    const image = req.file;
    if (!image) {
        throw new apiError_1.default(false, 400, "image is required");
    }
    const uploadToR2 = yield (0, r2_1.uploadFileToR2)(image);
    let story;
    if (existingStory) {
        // Update existing
        story = yield db_1.default.heritageStory.update({
            where: { id: existingStory.id },
            data: {
                tagline,
                title,
                description,
                imageUrl,
                buttonText,
                buttonLink,
            },
        });
    }
    else {
        // Create new if strictly needed (first time setup)
        story = yield db_1.default.heritageStory.create({
            data: {
                tagline: tagline || "The Philosophy",
                title: title || "Celebrating India's Artisanal Legacy",
                description: description || "Default description...",
                imageUrl: uploadToR2.url || "",
                buttonText: buttonText || "Read More",
                buttonLink: buttonLink || "/about",
            },
        });
    }
    return res.status(200).json(new apiResponse_1.default(true, 200, "Heritage story updated successfully", story));
}));
