"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteProvince = exports.updateProvince = exports.createProvince = exports.getAllProvinces = void 0;
const db_1 = __importDefault(require("../DB/db"));
const asyncHandler_1 = __importDefault(require("../utils/asyncHandler"));
// =============================
// GET All Provinces (No Pagination)
// =============================
exports.getAllProvinces = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const provinces = yield db_1.default.province.findMany({
        orderBy: { name: "asc" },
        include: {
            country: true,
            schools: true,
            projects: true,
            users: true,
            legalCases: true,
        },
    });
    return res.json({
        success: true,
        message: "All provinces fetched successfully",
        data: provinces,
    });
}));
// =============================
// 1. CREATE Province
// =============================
exports.createProvince = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { name, code, countryId } = req.body;
    if (!name || !code || !countryId) {
        return res.status(400).json({
            success: false,
            message: "name, code and countryId are required",
        });
    }
    const newProvince = yield db_1.default.province.create({
        data: {
            name,
            code,
            countryId,
        },
    });
    return res.status(201).json({
        success: true,
        message: "Province created successfully",
        data: newProvince,
    });
}));
// =============================
// 2. UPDATE Province
// =============================
exports.updateProvince = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { id } = req.params;
    const { name, code, countryId } = req.body;
    const province = yield db_1.default.province.findUnique({ where: { id } });
    if (!province) {
        return res.status(404).json({
            success: false,
            message: "Province not found",
        });
    }
    const updatedProvince = yield db_1.default.province.update({
        where: { id },
        data: {
            name: name !== null && name !== void 0 ? name : province.name,
            code: code !== null && code !== void 0 ? code : province.code,
            countryId: countryId !== null && countryId !== void 0 ? countryId : province.countryId,
        },
    });
    return res.json({
        success: true,
        message: "Province updated successfully",
        data: updatedProvince,
    });
}));
// =============================
// 3. DELETE Province
// =============================
exports.deleteProvince = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { id } = req.params;
    const province = yield db_1.default.province.findUnique({ where: { id } });
    if (!province) {
        return res.status(404).json({
            success: false,
            message: "Province not found",
        });
    }
    yield db_1.default.province.delete({
        where: { id },
    });
    return res.json({
        success: true,
        message: "Province deleted successfully",
    });
}));
