"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const banner_controller_1 = require("../../controllers/admin/banner.controller");
const multerMiddleware_1 = __importDefault(require("../../middlewares/multerMiddleware"));
const router = (0, express_1.Router)();
// Banner Routes
router.get('/', banner_controller_1.getBanners);
router.post('/', multerMiddleware_1.default.single("imageFile"), banner_controller_1.createBanner);
router.put('/:id', banner_controller_1.updateBanner);
router.delete('/:id', banner_controller_1.deleteBanner);
exports.default = router;
