"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const product_controller_1 = require("../../controllers/admin/product.controller");
const multerMiddleware_1 = __importDefault(require("../../middlewares/multerMiddleware"));
const router = (0, express_1.Router)();
// --- Products ---
router.get('', product_controller_1.getProducts);
router.get('/:id', product_controller_1.getProductDetails);
router.post("/", multerMiddleware_1.default.array("images", 5), product_controller_1.createProduct);
router.put('/:id', product_controller_1.updateProduct);
router.delete('/:id', product_controller_1.deleteProduct);
exports.default = router;
