"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const country_controller_js_1 = require("../controllers/country.controller.js");
const authMiddleware_js_1 = require("../middlewares/authMiddleware.js");
const router = express_1.default.Router();
router.post('/', authMiddleware_js_1.jwtVerify, (0, authMiddleware_js_1.authorizeRoles)("admin"), country_controller_js_1.createCountryController);
router.get('/', country_controller_js_1.getAllCountriesController);
router.get('/:id', country_controller_js_1.getCountryByIdController);
router.put('/:id', authMiddleware_js_1.jwtVerify, country_controller_js_1.updateCountryController);
router.delete('/:id', authMiddleware_js_1.jwtVerify, (0, authMiddleware_js_1.authorizeRoles)('admin'), country_controller_js_1.deleteCountryController);
exports.default = router;
