import express from 'express';
import cors from 'cors';
import cookieParser from 'cookie-parser';
import bodyParser from 'body-parser';
import helmet from 'helmet';
import compression from 'compression';
import morgan from 'morgan';
import rateLimit from 'express-rate-limit';
import admin from 'firebase-admin';
import errorHandler from './helpers/errorHandler';

// Import Routes
import authRoutes from './routes/auth.routes.js';
import notificationRoutes from './routes/notification.routes';
import productRoutes from './routes/product.routes';
import userRoutes from './routes/user.routes';
import cartRoutes from './routes/cart.routes';
import addressRoutes from './routes/address.routes';
import categoryRoutes from './routes/category.routes';
import dashboardRoutes from './routes/admin/dashboard.routes';
import customerRoutes from './routes/admin/customer.routes';
import adminCategoryRoutes from './routes/admin/category.routes';
import inventoryRoutes from './routes/admin/inventory.routes';
import adminOrderRoutes from './routes/admin/order.routes';
import supportRoutes from './routes/admin/support.routes';
import marketingRoutes from './routes/admin/marketing.routes';
import announcementsRoutes from './routes/admin/announcement.routes';
import bannerRoutes from './routes/admin/banner.routes';
import reviewRoutes from './routes/admin/review.routes';
import variantsRoutes from './routes/admin/variant.routes';
import adminProductRoutes from './routes/admin/product.routes';
import settingRoutes from './routes/admin/setting.routes';
import featuredRoutes from './routes/admin/featured.routes';
import bentoRoutes from './routes/admin/featured-category.routes';
import wishlistRoutes from './routes/wishlist.routes';
import checkoutRoutes from './routes/checkout.routes';
import cmsRoutes from './routes/cms.routes';
import featuredBannersRoutes from './routes/admin/featuredBanner.routes'


const app = express();

// 🌐 CORS Configuration
app.use(
  cors({
    origin: [process.env.FRONTEND_URL!, process.env.FRONTEND_URL_ADMIN!],
    methods: ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'],
    credentials: true,
  })
);

// app.set('trust proxy', true);
//  Rate Limiting
// const limiter = rateLimit({
//   windowMs: 1 * 60 * 1000, // 1 minute
//   max: 50, // max 50 requests
//   handler: (req, res) => {
//     console.log(`Rate limit hit`);
//     res.status(429).json({ message: 'Too many requests, slow down!' });
//   },
//   standardHeaders: true,
//   legacyHeaders: false,
// });
// app.use(limiter);

// 🧩 Global Middlewares
app.use(cookieParser());
app.use(helmet());
app.use(compression());
app.use(morgan('short'));
app.use(express.json({ limit: '5mb' }));
app.use(bodyParser.urlencoded({ extended: true, limit: '5mb' }));
app.use(express.static('./public'));

// 🧯 Error Handler Middleware
// app.use(errorHandler);

// 🩵 Health Check Route
app.get('/', async (req, res) => {
  return res.status(200).json({ success: false, message: 'nice to meet' });
});

// 🧭 Register All Routes
app.use('/api/v1/auth', authRoutes);
app.use('/api/v1/users', userRoutes);
app.use('/api/v1/product', productRoutes);
app.use('/api/v1/notifications', notificationRoutes);
app.use('/api/v1/cart', cartRoutes);
app.use('/api/v1/address', addressRoutes);
app.use('/api/v1/category', categoryRoutes);

// admin routes
app.use('/api/v1/admin/dashboard', dashboardRoutes);
app.use('/api/v1/admin/customer', customerRoutes);
app.use('/api/v1/admin/category', adminCategoryRoutes);
app.use('/api/v1/admin/inventory', inventoryRoutes);
app.use('/api/v1/admin/order', adminOrderRoutes);
app.use('/api/v1/admin/support', supportRoutes);
app.use('/api/v1/admin/marketing', marketingRoutes);
app.use('/api/v1/admin/announcements',announcementsRoutes)
app.use('/api/v1/admin/banner',bannerRoutes)
app.use('/api/v1/admin/reviews',reviewRoutes)
app.use('/api/v1/admin/variants',variantsRoutes)
app.use('/api/v1/admin/products',adminProductRoutes)
app.use('/api/v1/admin/settings',settingRoutes)
app.use('/api/v1/admin/featured',featuredRoutes)
app.use('/api/v1/admin/featuredbanners',featuredBannersRoutes)
app.use('/api/v1/admin/bento',bentoRoutes)
app.use('/api/v1/wishlist',wishlistRoutes)
app.use('/api/v1/checkout',checkoutRoutes)
app.use('/api/v1/cms',cmsRoutes)




export { app, admin };

