import { Router } from 'express';
import { getBentoItems,createBentoItem,updateBentoItem,deleteBentoItem } from '../../controllers/admin/featured-category.controller';
import upload from '../../middlewares/multerMiddleware';


const router = Router();

// Bento Grid Routes
router.get('/', getBentoItems);
router.post('/', upload.single("image"), createBentoItem);
router.put('/:id',  updateBentoItem);
router.delete('/:id', deleteBentoItem);

export default router;