import { Router } from 'express';

import { jwtVerify, authorizeRoles } from '../middlewares/authMiddleware.js';
import { getUserCartItem ,getCartItemCount, decrementCartItem, incrementCartItem} from '../controllers/cart.controller.js';
import { addToCart } from '../controllers/cart.controller.js';
;


const router = Router();

// router.use(jwtVerify);

router.get('/:id', getUserCartItem);
router.post('/addToCart', addToCart);
router.put("/increment/:cartItemId", incrementCartItem);
router.put("/decrement/:cartItemId", decrementCartItem);
router.get('/cartitemCount/:id', getCartItemCount);

export default router;
