import express from 'express';
import { getDiscountedProducts, getFeaturesProducts, getMonthlyFavorites, getProductById, getProducts } from '../controllers/product.controller.js';
import { authorizeRoles, jwtVerify } from '../middlewares/authMiddleware.js';

const router = express.Router();


router.get('/', getProducts);
router.get('/:id', getProductById);
router.get("/favorites/monthly", getMonthlyFavorites);
router.get("/discount/new", getDiscountedProducts);
router.get("/features/new", getFeaturesProducts);


export default router;
