import { Router } from 'express';
import {
  getAllUsers,

  getOneUser,
  getUserAccountDetails,
  removeCartItem,
  getTaxAndShipping,
 
} from '../controllers/user.controller.js';
import { jwtVerify, authorizeRoles } from '../middlewares/authMiddleware.js';


const router = Router();

// router.use(jwtVerify);



router.get('/userAccount/:id', getUserAccountDetails);



router.delete('/removecartItem/:itemId', removeCartItem);



router.get("/tax-shipping",getTaxAndShipping)


router.get('/', getAllUsers);

// get only one user
router.get('/:id', getOneUser);


export default router;
